/*
 * MATLAB Compiler: 3.0
 * Date: Mon Nov 03 11:55:29 2003
 * Arguments: "-B" "macro_default" "-O" "all" "-O" "fold_scalar_mxarrays:on"
 * "-O" "fold_non_scalar_mxarrays:on" "-O" "optimize_integer_for_loops:on" "-O"
 * "array_indexing:on" "-O" "optimize_conditionals:on" "-m" "-W" "main" "-L"
 * "C" "-t" "-T" "link:exe" "-h" "libmmfile.mlib" "DancingMonkeys" 
 */
#include "mkdir.h"
#include "mwservices.h"
#include "general_private_cdsafewindir.h"
#include "libmatlbm.h"
#include "libmmfile.h"
#include "strread.h"
static mxArray * _mxarray0_;
static mxArray * _mxarray1_;

static mxChar _array3_[35] = { 'M', 'A', 'T', 'L', 'A', 'B', ':', 'M', 'K',
                               'D', 'I', 'R', ':', 'N', 'u', 'm', 'b', 'e',
                               'r', 'O', 'f', 'I', 'n', 'p', 'u', 't', 'A',
                               'r', 'g', 'u', 'm', 'e', 'n', 't', 's' };
static mxArray * _mxarray2_;

static mxChar _array5_[25] = { 'M', 'A', 'T', 'L', 'A', 'B', ':', 'M', 'K',
                               'D', 'I', 'R', ':', 'A', 'r', 'g', 'u', 'm',
                               'e', 'n', 't', 'T', 'y', 'p', 'e' };
static mxArray * _mxarray4_;

static mxChar _array7_[25] = { 'A', 'r', 'g', 'u', 'm', 'e', 'n', 't', 's',
                               ' ', 'm', 'u', 's', 't', ' ', 'b', 'e', ' ',
                               's', 't', 'r', 'i', 'n', 'g', 's' };
static mxArray * _mxarray6_;
static mxArray * _mxarray8_;
static mxArray * _mxarray9_;

static mxChar _array11_[36] = { 'M', 'A', 'T', 'L', 'A', 'B', ':', 'M', 'K',
                                'D', 'I', 'R', ':', 'N', 'u', 'm', 'b', 'e',
                                'r', 'O', 'f', 'O', 'u', 't', 'p', 'u', 't',
                                'A', 'r', 'g', 'u', 'm', 'e', 'n', 't', 's' };
static mxArray * _mxarray10_;
static mxArray * _mxarray12_;
static mxArray * _mxarray13_;

static mxChar _array15_[34] = { 'M', 'A', 'T', 'L', 'A', 'B', ':', 'M', 'K',
                                'D', 'I', 'R', ':', 'A', 'r', 'g', 'u', 'm',
                                'e', 'n', 't', 'I', 'n', 'd', 'e', 't', 'e',
                                'r', 'm', 'i', 'n', 'a', 't', 'e' };
static mxArray * _mxarray14_;

static mxChar _array17_[45] = { 'S', 'e', 'c', 'o', 'n', 'd', ' ', 'd', 'i',
                                'r', 'e', 'c', 't', 'o', 'r', 'y', ' ', 'a',
                                'r', 'g', 'u', 'm', 'e', 'n', 't', ' ', 'i',
                                's', ' ', 'a', 'n', ' ', 'e', 'm', 'p', 't',
                                'y', ' ', 's', 't', 'r', 'i', 'n', 'g', '.' };
static mxArray * _mxarray16_;

static mxChar _array19_[4] = { 'p', 'a', 't', 'h' };
static mxArray * _mxarray18_;

static mxChar _array21_[2] = { 0x005c, 0x005c };
static mxArray * _mxarray20_;

static mxChar _array23_[27] = { 'M', 'A', 'T', 'L', 'A', 'B', ':', 'M', 'K',
                                'D', 'I', 'R', ':', 'D', 'i', 'r', 'e', 'c',
                                't', 'o', 'r', 'y', 'I', 's', 'U', 'N', 'C' };
static mxArray * _mxarray22_;

static mxChar _array25_[37] = { 'C', 'a', 'n', 'n', 'o', 't', ' ', 'c',
                                'r', 'e', 'a', 't', 'e', ' ', 'U', 'N',
                                'C', ' ', 'd', 'i', 'r', 'e', 'c', 't',
                                'o', 'r', 'y', ' ', 'i', 'n', 's', 'i',
                                'd', 'e', ' ', '%', 's' };
static mxArray * _mxarray24_;

static mxChar _array27_[1] = { ':' };
static mxArray * _mxarray26_;

static mxChar _array29_[41] = { 'M', 'A', 'T', 'L', 'A', 'B', ':', 'M', 'K',
                                'D', 'I', 'R', ':', 'D', 'i', 'r', 'e', 'c',
                                't', 'o', 'r', 'y', 'C', 'o', 'n', 't', 'a',
                                'i', 'n', 's', 'D', 'r', 'i', 'v', 'e', 'L',
                                'e', 't', 't', 'e', 'r' };
static mxArray * _mxarray28_;

static mxChar _array31_[42] = { 'C', 'a', 'n', 'n', 'o', 't', ' ', 'c', 'r',
                                'e', 'a', 't', 'e', ' ', 'a', 'b', 's', 'o',
                                'l', 'u', 't', 'e', ' ', 'd', 'i', 'r', 'e',
                                'c', 't', 'o', 'r', 'y', ' ', 'i', 'n', 's',
                                'i', 'd', 'e', ' ', '%', 's' };
static mxArray * _mxarray30_;

static mxChar _array33_[1] = { '"' };
static mxArray * _mxarray32_;

static mxChar _array35_[30] = { 'D', 'i', 'r', 'e', 'c', 't', 'o', 'r',
                                'y', ' ', '"', '%', 's', '"', ' ', 'a',
                                'l', 'r', 'e', 'a', 'd', 'y', ' ', 'e',
                                'x', 'i', 's', 't', 's', '.' };
static mxArray * _mxarray34_;

static mxChar _array37_[28] = { 'M', 'A', 'T', 'L', 'A', 'B', ':',
                                'M', 'K', 'D', 'I', 'R', ':', 'D',
                                'i', 'r', 'e', 'c', 't', 'o', 'r',
                                'y', 'E', 'x', 'i', 's', 't', 's' };
static mxArray * _mxarray36_;

static mxChar _array39_[1] = { 0x005c };
static mxArray * _mxarray38_;

static mxChar _array41_[9] = { 'm', 'k', 'd', 'i', 'r', ' ', '-', 'p', ' ' };
static mxArray * _mxarray40_;

static mxChar _array43_[1] = { '/' };
static mxArray * _mxarray42_;

static mxChar _array45_[20] = { 'M', 'A', 'T', 'L', 'A', 'B', ':',
                                'M', 'K', 'D', 'I', 'R', ':', 'O',
                                'S', 'E', 'r', 'r', 'o', 'r' };
static mxArray * _mxarray44_;

static mxChar _array47_[2] = { '%', 's' };
static mxArray * _mxarray46_;

static mxChar _array49_[9] = { 'd', 'e', 'l', 'i', 'm', 'i', 't', 'e', 'r' };
static mxArray * _mxarray48_;

static mxChar _array51_[2] = { 0x005c, 'n' };
static mxArray * _mxarray50_;

static mxChar _array53_[3] = { 'v', 'e', 'r' };
static mxArray * _mxarray52_;

static mxChar _array55_[10] = { 'W', 'i', 'n', 'd', 'o',
                                'w', 's', ' ', '9', '5' };
static mxArray * _mxarray54_;

static mxChar _array57_[10] = { 'W', 'i', 'n', 'd', 'o',
                                'w', 's', ' ', '9', '8' };
static mxArray * _mxarray56_;

static mxChar _array59_[18] = { 'W', 'i', 'n', 'd', 'o', 'w', 's', ' ', 'M',
                                'i', 'l', 'l', 'e', 'n', 'n', 'i', 'u', 'm' };
static mxArray * _mxarray58_;

static mxChar _array61_[6] = { 'm', 'k', 'd', 'i', 'r', ' ' };
static mxArray * _mxarray60_;

static mxChar _array63_[2] = { '"', '~' };
static mxArray * _mxarray62_;

static mxChar _array65_[2] = { '/', '"' };
static mxArray * _mxarray64_;

void InitializeModule_mkdir(void) {
    _mxarray0_ = mclInitializeDouble(1.0);
    _mxarray1_ = mclInitializeDouble(2.0);
    _mxarray2_ = mclInitializeString(35, _array3_);
    _mxarray4_ = mclInitializeString(25, _array5_);
    _mxarray6_ = mclInitializeString(25, _array7_);
    _mxarray8_ = mclInitializeDouble(-1.0);
    _mxarray9_ = mclInitializeDouble(3.0);
    _mxarray10_ = mclInitializeString(36, _array11_);
    _mxarray12_ = mclInitializeCharVector(0, 0, (mxChar *)NULL);
    _mxarray13_ = mclInitializeDouble(0.0);
    _mxarray14_ = mclInitializeString(34, _array15_);
    _mxarray16_ = mclInitializeString(45, _array17_);
    _mxarray18_ = mclInitializeString(4, _array19_);
    _mxarray20_ = mclInitializeString(2, _array21_);
    _mxarray22_ = mclInitializeString(27, _array23_);
    _mxarray24_ = mclInitializeString(37, _array25_);
    _mxarray26_ = mclInitializeString(1, _array27_);
    _mxarray28_ = mclInitializeString(41, _array29_);
    _mxarray30_ = mclInitializeString(42, _array31_);
    _mxarray32_ = mclInitializeString(1, _array33_);
    _mxarray34_ = mclInitializeString(30, _array35_);
    _mxarray36_ = mclInitializeString(28, _array37_);
    _mxarray38_ = mclInitializeString(1, _array39_);
    _mxarray40_ = mclInitializeString(9, _array41_);
    _mxarray42_ = mclInitializeString(1, _array43_);
    _mxarray44_ = mclInitializeString(20, _array45_);
    _mxarray46_ = mclInitializeString(2, _array47_);
    _mxarray48_ = mclInitializeString(9, _array49_);
    _mxarray50_ = mclInitializeString(2, _array51_);
    _mxarray52_ = mclInitializeString(3, _array53_);
    _mxarray54_ = mclInitializeString(10, _array55_);
    _mxarray56_ = mclInitializeString(10, _array57_);
    _mxarray58_ = mclInitializeString(18, _array59_);
    _mxarray60_ = mclInitializeString(6, _array61_);
    _mxarray62_ = mclInitializeString(2, _array63_);
    _mxarray64_ = mclInitializeString(2, _array65_);
}

void TerminateModule_mkdir(void) {
    mxDestroyArray(_mxarray64_);
    mxDestroyArray(_mxarray62_);
    mxDestroyArray(_mxarray60_);
    mxDestroyArray(_mxarray58_);
    mxDestroyArray(_mxarray56_);
    mxDestroyArray(_mxarray54_);
    mxDestroyArray(_mxarray52_);
    mxDestroyArray(_mxarray50_);
    mxDestroyArray(_mxarray48_);
    mxDestroyArray(_mxarray46_);
    mxDestroyArray(_mxarray44_);
    mxDestroyArray(_mxarray42_);
    mxDestroyArray(_mxarray40_);
    mxDestroyArray(_mxarray38_);
    mxDestroyArray(_mxarray36_);
    mxDestroyArray(_mxarray34_);
    mxDestroyArray(_mxarray32_);
    mxDestroyArray(_mxarray30_);
    mxDestroyArray(_mxarray28_);
    mxDestroyArray(_mxarray26_);
    mxDestroyArray(_mxarray24_);
    mxDestroyArray(_mxarray22_);
    mxDestroyArray(_mxarray20_);
    mxDestroyArray(_mxarray18_);
    mxDestroyArray(_mxarray16_);
    mxDestroyArray(_mxarray14_);
    mxDestroyArray(_mxarray13_);
    mxDestroyArray(_mxarray12_);
    mxDestroyArray(_mxarray10_);
    mxDestroyArray(_mxarray9_);
    mxDestroyArray(_mxarray8_);
    mxDestroyArray(_mxarray6_);
    mxDestroyArray(_mxarray4_);
    mxDestroyArray(_mxarray2_);
    mxDestroyArray(_mxarray1_);
    mxDestroyArray(_mxarray0_);
}

static mxArray * mlfMkdir_ConsolidateMkdirStatus(mxArray * Status,
                                                 mxArray * OSMessage);
static void mlxMkdir_ConsolidateMkdirStatus(int nlhs,
                                            mxArray * plhs[],
                                            int nrhs,
                                            mxArray * prhs[]);
static mxArray * mlfMkdir_setwinmkdir(void);
static void mlxMkdir_setwinmkdir(int nlhs,
                                 mxArray * plhs[],
                                 int nrhs,
                                 mxArray * prhs[]);
static mxArray * mlfMkdir_winmkdir(mxArray * * OSMessage,
                                   mxArray * Directory,
                                   mxArray * WinSwitches);
static void mlxMkdir_winmkdir(int nlhs,
                              mxArray * plhs[],
                              int nrhs,
                              mxArray * prhs[]);
static mxArray * mlfMkdir_validpath(mxArray * DirName, mxArray * NewDirName);
static void mlxMkdir_validpath(int nlhs,
                               mxArray * plhs[],
                               int nrhs,
                               mxArray * prhs[]);
static mxArray * Mmkdir(int nargout_, mxArray * varargin);
static mxArray * Mmkdir_ConsolidateMkdirStatus(int nargout_,
                                               mxArray * Status,
                                               mxArray * OSMessage);
static mxArray * Mmkdir_setwinmkdir(int nargout_);
static mxArray * Mmkdir_winmkdir(mxArray * * OSMessage,
                                 int nargout_,
                                 mxArray * Directory,
                                 mxArray * WinSwitches);
static mxArray * Mmkdir_validpath(int nargout_,
                                  mxArray * DirName,
                                  mxArray * NewDirName);

static mexFunctionTableEntry local_function_table_[4]
  = { { "ConsolidateMkdirStatus",
        mlxMkdir_ConsolidateMkdirStatus, 2, 1, NULL },
      { "setwinmkdir", mlxMkdir_setwinmkdir, 0, 1, NULL },
      { "winmkdir", mlxMkdir_winmkdir, 2, 2, NULL },
      { "validpath", mlxMkdir_validpath, 2, 1, NULL } };

_mexLocalFunctionTable _local_function_table_mkdir
  = { 4, local_function_table_ };

/*
 * The function "mlfNMkdir" contains the nargout interface for the "mkdir"
 * M-function from file "c:\matlab65\toolbox\matlab\general\mkdir.m" (lines
 * 1-201). This interface is only produced if the M-function uses the special
 * variable "nargout". The nargout interface allows the number of requested
 * outputs to be specified via the nargout argument, as opposed to the normal
 * interface which dynamically calculates the number of outputs based on the
 * number of non-NULL inputs it receives. This function processes any input
 * arguments and passes them to the implementation version of the function,
 * appearing above.
 */
mxArray * mlfNMkdir(int nargout, mlfVarargoutList * varargout, ...) {
    mxArray * varargin = NULL;
    mlfVarargin(&varargin, varargout, 0);
    mlfEnterNewContext(0, -1, varargin);
    nargout += mclNargout(varargout);
    *mlfGetVarargoutCellPtr(varargout) = Mmkdir(nargout, varargin);
    mlfRestorePreviousContext(0, 0);
    mxDestroyArray(varargin);
    return mlfAssignOutputs(varargout);
}

/*
 * The function "mlfMkdir" contains the normal interface for the "mkdir"
 * M-function from file "c:\matlab65\toolbox\matlab\general\mkdir.m" (lines
 * 1-201). This function processes any input arguments and passes them to the
 * implementation version of the function, appearing above.
 */
mxArray * mlfMkdir(mlfVarargoutList * varargout, ...) {
    mxArray * varargin = NULL;
    int nargout = 0;
    mlfVarargin(&varargin, varargout, 0);
    mlfEnterNewContext(0, -1, varargin);
    nargout += mclNargout(varargout);
    *mlfGetVarargoutCellPtr(varargout) = Mmkdir(nargout, varargin);
    mlfRestorePreviousContext(0, 0);
    mxDestroyArray(varargin);
    return mlfAssignOutputs(varargout);
}

/*
 * The function "mlfVMkdir" contains the void interface for the "mkdir"
 * M-function from file "c:\matlab65\toolbox\matlab\general\mkdir.m" (lines
 * 1-201). The void interface is only produced if the M-function uses the
 * special variable "nargout", and has at least one output. The void interface
 * function specifies zero output arguments to the implementation version of
 * the function, and in the event that the implementation version still returns
 * an output (which, in MATLAB, would be assigned to the "ans" variable), it
 * deallocates the output. This function processes any input arguments and
 * passes them to the implementation version of the function, appearing above.
 */
void mlfVMkdir(mxArray * synthetic_varargin_argument, ...) {
    mxArray * varargin = NULL;
    mxArray * varargout = NULL;
    mlfVarargin(&varargin, synthetic_varargin_argument, 1);
    mlfEnterNewContext(0, -1, varargin);
    varargout = Mmkdir(0, synthetic_varargin_argument);
    mlfRestorePreviousContext(0, 0);
    mxDestroyArray(varargin);
}

/*
 * The function "mlxMkdir" contains the feval interface for the "mkdir"
 * M-function from file "c:\matlab65\toolbox\matlab\general\mkdir.m" (lines
 * 1-201). The feval function calls the implementation version of mkdir through
 * this function. This function processes any input arguments and passes them
 * to the implementation version of the function, appearing above.
 */
void mlxMkdir(int nlhs, mxArray * plhs[], int nrhs, mxArray * prhs[]) {
    mxArray * mprhs[1];
    mxArray * mplhs[1];
    int i;
    for (i = 0; i < 1; ++i) {
        mplhs[i] = NULL;
    }
    mlfEnterNewContext(0, 0);
    mprhs[0] = NULL;
    mlfAssign(&mprhs[0], mclCreateVararginCell(nrhs, prhs));
    mplhs[0] = Mmkdir(nlhs, mprhs[0]);
    mclAssignVarargoutCell(0, nlhs, plhs, mplhs[0]);
    mlfRestorePreviousContext(0, 0);
    mxDestroyArray(mprhs[0]);
}

/*
 * The function "mlfMkdir_ConsolidateMkdirStatus" contains the normal interface
 * for the "mkdir/ConsolidateMkdirStatus" M-function from file
 * "c:\matlab65\toolbox\matlab\general\mkdir.m" (lines 201-226). This function
 * processes any input arguments and passes them to the implementation version
 * of the function, appearing above.
 */
static mxArray * mlfMkdir_ConsolidateMkdirStatus(mxArray * Status,
                                                 mxArray * OSMessage) {
    int nargout = 1;
    mxArray * Success = NULL;
    mlfEnterNewContext(0, 2, Status, OSMessage);
    Success = Mmkdir_ConsolidateMkdirStatus(nargout, Status, OSMessage);
    mlfRestorePreviousContext(0, 2, Status, OSMessage);
    return mlfReturnValue(Success);
}

/*
 * The function "mlxMkdir_ConsolidateMkdirStatus" contains the feval interface
 * for the "mkdir/ConsolidateMkdirStatus" M-function from file
 * "c:\matlab65\toolbox\matlab\general\mkdir.m" (lines 201-226). The feval
 * function calls the implementation version of mkdir/ConsolidateMkdirStatus
 * through this function. This function processes any input arguments and
 * passes them to the implementation version of the function, appearing above.
 */
static void mlxMkdir_ConsolidateMkdirStatus(int nlhs,
                                            mxArray * plhs[],
                                            int nrhs,
                                            mxArray * prhs[]) {
    mxArray * mprhs[2];
    mxArray * mplhs[1];
    int i;
    if (nlhs > 1) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: mkdir/ConsolidateMkdirStatus Line: 201"
            " Column: 1 The function \"mkdir/ConsolidateMkdirStatus\" was"
            " called with more than the declared number of outputs (1)."),
          NULL);
    }
    if (nrhs > 2) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: mkdir/ConsolidateMkdirStatus Line: 201"
            " Column: 1 The function \"mkdir/ConsolidateMkdirStatus\" was"
            " called with more than the declared number of inputs (2)."),
          NULL);
    }
    for (i = 0; i < 1; ++i) {
        mplhs[i] = NULL;
    }
    for (i = 0; i < 2 && i < nrhs; ++i) {
        mprhs[i] = prhs[i];
    }
    for (; i < 2; ++i) {
        mprhs[i] = NULL;
    }
    mlfEnterNewContext(0, 2, mprhs[0], mprhs[1]);
    mplhs[0] = Mmkdir_ConsolidateMkdirStatus(nlhs, mprhs[0], mprhs[1]);
    mlfRestorePreviousContext(0, 2, mprhs[0], mprhs[1]);
    plhs[0] = mplhs[0];
}

/*
 * The function "mlfMkdir_setwinmkdir" contains the normal interface for the
 * "mkdir/setwinmkdir" M-function from file
 * "c:\matlab65\toolbox\matlab\general\mkdir.m" (lines 226-251). This function
 * processes any input arguments and passes them to the implementation version
 * of the function, appearing above.
 */
static mxArray * mlfMkdir_setwinmkdir(void) {
    int nargout = 1;
    mxArray * WinMkdirSwitches = NULL;
    mlfEnterNewContext(0, 0);
    WinMkdirSwitches = Mmkdir_setwinmkdir(nargout);
    mlfRestorePreviousContext(0, 0);
    return mlfReturnValue(WinMkdirSwitches);
}

/*
 * The function "mlxMkdir_setwinmkdir" contains the feval interface for the
 * "mkdir/setwinmkdir" M-function from file
 * "c:\matlab65\toolbox\matlab\general\mkdir.m" (lines 226-251). The feval
 * function calls the implementation version of mkdir/setwinmkdir through this
 * function. This function processes any input arguments and passes them to the
 * implementation version of the function, appearing above.
 */
static void mlxMkdir_setwinmkdir(int nlhs,
                                 mxArray * plhs[],
                                 int nrhs,
                                 mxArray * prhs[]) {
    mxArray * mplhs[1];
    int i;
    if (nlhs > 1) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: mkdir/setwinmkdir Line: 226 Col"
            "umn: 1 The function \"mkdir/setwinmkdir\" was called "
            "with more than the declared number of outputs (1)."),
          NULL);
    }
    if (nrhs > 0) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: mkdir/setwinmkdir Line: 226 Col"
            "umn: 1 The function \"mkdir/setwinmkdir\" was called "
            "with more than the declared number of inputs (0)."),
          NULL);
    }
    for (i = 0; i < 1; ++i) {
        mplhs[i] = NULL;
    }
    mlfEnterNewContext(0, 0);
    mplhs[0] = Mmkdir_setwinmkdir(nlhs);
    mlfRestorePreviousContext(0, 0);
    plhs[0] = mplhs[0];
}

/*
 * The function "mlfMkdir_winmkdir" contains the normal interface for the
 * "mkdir/winmkdir" M-function from file
 * "c:\matlab65\toolbox\matlab\general\mkdir.m" (lines 251-290). This function
 * processes any input arguments and passes them to the implementation version
 * of the function, appearing above.
 */
static mxArray * mlfMkdir_winmkdir(mxArray * * OSMessage,
                                   mxArray * Directory,
                                   mxArray * WinSwitches) {
    int nargout = 1;
    mxArray * Status = NULL;
    mxArray * OSMessage__ = NULL;
    mlfEnterNewContext(1, 2, OSMessage, Directory, WinSwitches);
    if (OSMessage != NULL) {
        ++nargout;
    }
    Status = Mmkdir_winmkdir(&OSMessage__, nargout, Directory, WinSwitches);
    mlfRestorePreviousContext(1, 2, OSMessage, Directory, WinSwitches);
    if (OSMessage != NULL) {
        mclCopyOutputArg(OSMessage, OSMessage__);
    } else {
        mxDestroyArray(OSMessage__);
    }
    return mlfReturnValue(Status);
}

/*
 * The function "mlxMkdir_winmkdir" contains the feval interface for the
 * "mkdir/winmkdir" M-function from file
 * "c:\matlab65\toolbox\matlab\general\mkdir.m" (lines 251-290). The feval
 * function calls the implementation version of mkdir/winmkdir through this
 * function. This function processes any input arguments and passes them to the
 * implementation version of the function, appearing above.
 */
static void mlxMkdir_winmkdir(int nlhs,
                              mxArray * plhs[],
                              int nrhs,
                              mxArray * prhs[]) {
    mxArray * mprhs[2];
    mxArray * mplhs[2];
    int i;
    if (nlhs > 2) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: mkdir/winmkdir Line: 251 Colu"
            "mn: 1 The function \"mkdir/winmkdir\" was called wi"
            "th more than the declared number of outputs (2)."),
          NULL);
    }
    if (nrhs > 2) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: mkdir/winmkdir Line: 251 Colu"
            "mn: 1 The function \"mkdir/winmkdir\" was called wi"
            "th more than the declared number of inputs (2)."),
          NULL);
    }
    for (i = 0; i < 2; ++i) {
        mplhs[i] = NULL;
    }
    for (i = 0; i < 2 && i < nrhs; ++i) {
        mprhs[i] = prhs[i];
    }
    for (; i < 2; ++i) {
        mprhs[i] = NULL;
    }
    mlfEnterNewContext(0, 2, mprhs[0], mprhs[1]);
    mplhs[0] = Mmkdir_winmkdir(&mplhs[1], nlhs, mprhs[0], mprhs[1]);
    mlfRestorePreviousContext(0, 2, mprhs[0], mprhs[1]);
    plhs[0] = mplhs[0];
    for (i = 1; i < 2 && i < nlhs; ++i) {
        plhs[i] = mplhs[i];
    }
    for (; i < 2; ++i) {
        mxDestroyArray(mplhs[i]);
    }
}

/*
 * The function "mlfMkdir_validpath" contains the normal interface for the
 * "mkdir/validpath" M-function from file
 * "c:\matlab65\toolbox\matlab\general\mkdir.m" (lines 290-309). This function
 * processes any input arguments and passes them to the implementation version
 * of the function, appearing above.
 */
static mxArray * mlfMkdir_validpath(mxArray * DirName, mxArray * NewDirName) {
    int nargout = 1;
    mxArray * Directory = NULL;
    mlfEnterNewContext(0, 2, DirName, NewDirName);
    Directory = Mmkdir_validpath(nargout, DirName, NewDirName);
    mlfRestorePreviousContext(0, 2, DirName, NewDirName);
    return mlfReturnValue(Directory);
}

/*
 * The function "mlxMkdir_validpath" contains the feval interface for the
 * "mkdir/validpath" M-function from file
 * "c:\matlab65\toolbox\matlab\general\mkdir.m" (lines 290-309). The feval
 * function calls the implementation version of mkdir/validpath through this
 * function. This function processes any input arguments and passes them to the
 * implementation version of the function, appearing above.
 */
static void mlxMkdir_validpath(int nlhs,
                               mxArray * plhs[],
                               int nrhs,
                               mxArray * prhs[]) {
    mxArray * mprhs[2];
    mxArray * mplhs[1];
    int i;
    if (nlhs > 1) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: mkdir/validpath Line: 290 Colu"
            "mn: 1 The function \"mkdir/validpath\" was called wi"
            "th more than the declared number of outputs (1)."),
          NULL);
    }
    if (nrhs > 2) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: mkdir/validpath Line: 290 Col"
            "umn: 1 The function \"mkdir/validpath\" was called "
            "with more than the declared number of inputs (2)."),
          NULL);
    }
    for (i = 0; i < 1; ++i) {
        mplhs[i] = NULL;
    }
    for (i = 0; i < 2 && i < nrhs; ++i) {
        mprhs[i] = prhs[i];
    }
    for (; i < 2; ++i) {
        mprhs[i] = NULL;
    }
    mlfEnterNewContext(0, 2, mprhs[0], mprhs[1]);
    mplhs[0] = Mmkdir_validpath(nlhs, mprhs[0], mprhs[1]);
    mlfRestorePreviousContext(0, 2, mprhs[0], mprhs[1]);
    plhs[0] = mplhs[0];
}

/*
 * The function "Mmkdir" is the implementation version of the "mkdir"
 * M-function from file "c:\matlab65\toolbox\matlab\general\mkdir.m" (lines
 * 1-201). It contains the actual compiled code for that M-function. It is a
 * static function and must only be called from one of the interface functions,
 * appearing below.
 */
/*
 * function varargout=mkdir(varargin)
 */
static mxArray * Mmkdir(int nargout_, mxArray * varargin) {
    mexLocalFunctionTable save_local_function_table_
      = mclSetCurrentLocalFunctionTable(&_local_function_table_mkdir);
    int nargin_ = mclNargin(-1, varargin, NULL);
    mxArray * varargout = NULL;
    mxArray * WinSwitches = NULL;
    mxArray * WarningID = NULL;
    mxArray * WarningMessage = NULL;
    mxArray * Directory = NULL;
    mxArray * NewDirName = NULL;
    mxArray * DirName = NULL;
    mxArray * PreWin2000 = NULL;
    mxArray * OSMessage = NULL;
    mxArray * Status = NULL;
    mxArray * ErrorID = NULL;
    mxArray * ErrorMessage = NULL;
    mxArray * OldDir = NULL;
    mxArray * Success = NULL;
    mxArray * ArgOutError = NULL;
    mxArray * ans = NULL;
    mxArray * ArgError = NULL;
    mclCopyArray(&varargin);
    /*
     * %MKDIR   Make new directory.
     * %   [SUCCESS,MESSAGE,MESSAGEID] = MKDIR(PARENTDIR,NEWDIR) makes a new directory,
     * %   NEWDIR, under the parent, PARENTDIR. While PARENTDIR may be an absolute
     * %   path, NEWDIR must be a relative path. When NEWDIR exists, MKDIR returns
     * %   SUCCESS = 1 and issues to the user a warning that the directory already
     * %   exists.
     * %
     * %   [SUCCESS,MESSAGE,MESSAGEID] = MKDIR(NEWDIR) creates the directory NEWDIR
     * %   in the current directory. 
     * %
     * %   [SUCCESS,MESSAGE,MESSAGEID] = MKDIR(PARENTDIR,NEWDIR) creates the
     * %   directory NEWDIR in the existing directory PARENTDIR. 
     * %
     * %   INPUT PARAMETERS:
     * %       PARENTDIR : string specifying the parent directory. See NOTE 1.
     * %       NEWDIR : string specifying the new directory. 
     * %
     * %   RETURN PARAMETERS:
     * %       SUCCESS: logical scalar, defining the outcome of MKDIR. 
     * %                1 : MKDIR executed successfully.
     * %                0 : an error occurred.
     * %       MESSAGE: string, defining the error or warning message. 
     * %                empty string : MKDIR executed successfully.
     * %                message : an error or warning message, as applicable.
     * %       MESSAGEID: string, defining the error or warning identifier.
     * %                  empty string : MKDIR executed successfully.
     * %                  message id: the MATLAB error or warning message identifier
     * %                  (see ERROR, LASTERR, WARNING, LASTWARN).
     * %
     * %   NOTE 1: UNC paths are supported. 
     * %
     * %   See also CD, COPYFILE, DELETE, DIR, FILEATTRIB, MOVEFILE, RMDIR.
     * 
     * %   JP Barnard
     * %   Copyright 1984-2002 The MathWorks, Inc. 
     * %   $Revision: 1.37 $ $Date: 2002/06/06 18:42:43 $
     * % -----------------------------------------------------------------------------
     * 
     * % Set up MKDIR
     * 
     * % test if source and destination arguments are strings
     * % handle input arguments
     * ArgError = nargchk(1,2,nargin);  % Number of input arguments must be 1 of 2.
     */
    mlfAssign(
      &ArgError, mlfNargchk(_mxarray0_, _mxarray1_, mlfScalar(nargin_)));
    /*
     * if ~isempty(ArgError)
     */
    if (mclNotBool(mlfIsempty(mclVv(ArgError, "ArgError")))) {
        /*
         * error('MATLAB:MKDIR:NumberOfInputArguments',ArgError);
         */
        mlfError(_mxarray2_, mclVv(ArgError, "ArgError"), NULL);
    /*
     * end
     */
    }
    /*
     * 
     * % check if additional arguments are strings
     * if ~isempty(varargin) & ~iscellstr(varargin) 
     */
    {
        mxArray * a_
          = mclInitialize(mclNot(mlfIsempty(mclVa(varargin, "varargin"))));
        if (mlfTobool(a_)
            && mlfTobool(
                 mclAnd(
                   a_, mclNot(mlfIscellstr(mclVa(varargin, "varargin")))))) {
            mxDestroyArray(a_);
            /*
             * error('MATLAB:MKDIR:ArgumentType','Arguments must be strings')
             */
            mlfError(_mxarray4_, _mxarray6_, NULL);
        } else {
            mxDestroyArray(a_);
        }
    /*
     * end
     */
    }
    /*
     * 
     * % handle output arguments
     * % Number of output arguments must be 1 to 3.
     * ArgOutError = nargoutchk(-1,3,nargout);  
     */
    mlfAssign(
      &ArgOutError, mlfNargoutchk(_mxarray8_, _mxarray9_, mlfScalar(nargout_)));
    /*
     * if ~isempty(ArgOutError)
     */
    if (mclNotBool(mlfIsempty(mclVv(ArgOutError, "ArgOutError")))) {
        /*
         * error('MATLAB:MKDIR:NumberOfOutputArguments',ArgOutError);
         */
        mlfError(_mxarray10_, mclVv(ArgOutError, "ArgOutError"), NULL);
    /*
     * end
     */
    }
    /*
     * 
     * % Initialise variables.
     * Success = true;
     */
    mlfAssign(&Success, mlfTrue(NULL));
    /*
     * OldDir = '';
     */
    mlfAssign(&OldDir, _mxarray12_);
    /*
     * ErrorMessage='';  % annotations to raw OS error message
     */
    mlfAssign(&ErrorMessage, _mxarray12_);
    /*
     * ErrorID = '';
     */
    mlfAssign(&ErrorID, _mxarray12_);
    /*
     * Status = 0;
     */
    mlfAssign(&Status, _mxarray13_);
    /*
     * OSMessage = '';   % raw OS message
     */
    mlfAssign(&OSMessage, _mxarray12_);
    /*
     * PreWin2000 = false;
     */
    mlfAssign(&PreWin2000, mlfFalse(NULL));
    /*
     * 
     * % handle input arguments
     * if nargin == 1
     */
    if (nargin_ == 1) {
        /*
         * % Mode 1: create a new directory inside current directory
         * DirName = pwd;
         */
        mlfAssign(&DirName, mlfPwd());
        /*
         * NewDirName = varargin{1};
         */
        mlfAssign(
          &NewDirName,
          mlfIndexRef(mclVa(varargin, "varargin"), "{?}", _mxarray0_));
    /*
     * 
     * elseif nargin == 2
     */
    } else if (nargin_ == 2) {
        /*
         * % Mode 2: create a new directory inside a specified directory
         * if ~isempty(varargin{2})
         */
        if (mclNotBool(
              mclFeval(
                mclValueVarargout(),
                mlxIsempty,
                mlfIndexRef(mclVa(varargin, "varargin"), "{?}", _mxarray1_),
                NULL))) {
            /*
             * DirName = varargin{1};
             */
            mlfAssign(
              &DirName,
              mlfIndexRef(mclVa(varargin, "varargin"), "{?}", _mxarray0_));
            /*
             * NewDirName = varargin{2};
             */
            mlfAssign(
              &NewDirName,
              mlfIndexRef(mclVa(varargin, "varargin"), "{?}", _mxarray1_));
        /*
         * else
         */
        } else {
            /*
             * error('MATLAB:MKDIR:ArgumentIndeterminate',...
             */
            mlfError(_mxarray14_, _mxarray16_, NULL);
        /*
         * 'Second directory argument is an empty string.');
         * end
         */
        }
    /*
     * end
     */
    }
    /*
     * 
     * 
     * % Build full path that has valid path syntax.
     * % Add double quotes around the source and destination files 
     * %	so as to support file names containing spaces.
     * Directory = validpath(DirName,NewDirName);
     */
    mlfAssign(
      &Directory,
      mlfMkdir_validpath(
        mclVv(DirName, "DirName"), mclVv(NewDirName, "NewDirName")));
    /*
     * 
     * % rehash non-toolbox directory path global
     * rehash path
     */
    mclPrintAns(&ans, mlfRehash(_mxarray18_));
    /*
     * % -----------------------------------------------------------------------------
     * % Attempt to make directory
     * 
     * try
     */
    mlfTry {
        /*
         * % Throw error if UNC path is found in new directory name
         * if strncmp('\\',NewDirName,2)
         */
        if (mlfTobool(
              mlfStrncmp(
                _mxarray20_, mclVv(NewDirName, "NewDirName"), _mxarray1_))) {
            /*
             * error('MATLAB:MKDIR:DirectoryIsUNC',...
             */
            mlfError(_mxarray22_, _mxarray24_, mclVv(DirName, "DirName"), NULL);
        /*
         * 'Cannot create UNC directory inside %s',DirName);
         * end
         */
        }
        /*
         * 
         * % Throw error if new directory name implies an absolute path.
         * if ~isempty(strfind(NewDirName,':'))
         */
        if (mclNotBool(
              mlfIsempty(
                mlfStrfind(mclVv(NewDirName, "NewDirName"), _mxarray26_)))) {
            /*
             * error('MATLAB:MKDIR:DirectoryContainsDriveLetter',...
             */
            mlfError(_mxarray28_, _mxarray30_, mclVv(DirName, "DirName"), NULL);
        /*
         * 'Cannot create absolute directory inside %s',DirName);
         * end
         */
        }
        /*
         * 
         * % Test for existance of directory
         * if ~isempty(dir(strrep(Directory,'"','')))
         */
        if (mclNotBool(
              mlfIsempty(
                mlfNDir(
                  1,
                  mlfStrrep(
                    mclVv(Directory, "Directory"),
                    _mxarray32_,
                    _mxarray12_))))) {
            /*
             * WarningMessage = sprintf('Directory "%s" already exists.', NewDirName);
             */
            mlfAssign(
              &WarningMessage,
              mlfSprintf(
                NULL, _mxarray34_, mclVv(NewDirName, "NewDirName"), NULL));
            /*
             * WarningID = 'MATLAB:MKDIR:DirectoryExists';
             */
            mlfAssign(&WarningID, _mxarray36_);
            /*
             * 
             * if nargout
             */
            if (nargout_ != 0) {
                /*
                 * varargout{1} = Success;
                 */
                mlfIndexAssign(
                  &varargout, "{?}", _mxarray0_, mclVv(Success, "Success"));
                /*
                 * varargout{2} = WarningMessage;
                 */
                mlfIndexAssign(
                  &varargout,
                  "{?}",
                  _mxarray1_,
                  mclVv(WarningMessage, "WarningMessage"));
                /*
                 * varargout{3} = WarningID;
                 */
                mlfIndexAssign(
                  &varargout, "{?}", _mxarray9_, mclVv(WarningID, "WarningID"));
            /*
             * else
             */
            } else {
                /*
                 * warning(WarningID, WarningMessage, NewDirName);
                 */
                mclAssignAns(
                  &ans,
                  mlfNWarning(
                    0,
                    NULL,
                    mclVv(WarningID, "WarningID"),
                    mclVv(WarningMessage, "WarningMessage"),
                    mclVv(NewDirName, "NewDirName"),
                    NULL));
            /*
             * end
             */
            }
            mclExitTryBlock();
            /*
             * return
             */
            goto return_;
        /*
         * end
         */
        }
        /*
         * 
         * % UNIX file system
         * 
         * if isunix
         */
        if (mlfTobool(mlfIsunix())) {
            /*
             * % ensure correct file separator
             * Directory = strrep(Directory,'\',filesep);
             */
            mlfAssign(
              &Directory,
              mlfStrrep(
                mclVv(Directory, "Directory"), _mxarray38_, mlfFilesep()));
            /*
             * 
             * % make directory structure
             * [Status, OSMessage] = unix(['mkdir -p ' Directory]); 
             */
            mlfAssign(
              &Status,
              mlfUnix(
                &OSMessage,
                mlfHorzcat(_mxarray40_, mclVv(Directory, "Directory"), NULL)));
        /*
         * 
         * % MS DOS file system
         * 
         * elseif ispc
         */
        } else if (mlfTobool(mlfIspc())) {
            /*
             * 
             * % Change to safe directory in Windows when UNC path cause failures
             * OldDir = cdsafewindir; % store current directory
             */
            mlfAssign(&OldDir, mlfGeneral_private_cdsafewindir());
            /*
             * 
             * % find version of Windows
             * WinSwitches = setwinmkdir;
             */
            mlfAssign(&WinSwitches, mlfMkdir_setwinmkdir());
            /*
             * 
             * % ensure correct file separator
             * Directory = strrep(Directory,'/',filesep);
             */
            mlfAssign(
              &Directory,
              mlfStrrep(
                mclVv(Directory, "Directory"), _mxarray42_, mlfFilesep()));
            /*
             * 
             * % make directory
             * [Status,OSMessage]=winmkdir(Directory,WinSwitches);
             */
            mlfAssign(
              &Status,
              mlfMkdir_winmkdir(
                &OSMessage,
                mclVv(Directory, "Directory"),
                mclVv(WinSwitches, "WinSwitches")));
            /*
             * 
             * % if changed to %windir%, restore original current directory
             * if ~isempty(OldDir)
             */
            if (mclNotBool(mlfIsempty(mclVv(OldDir, "OldDir")))) {
                /*
                 * cd(OldDir);
                 */
                mclAssignAns(&ans, mlfNCd(0, mclVv(OldDir, "OldDir")));
            /*
             * end
             */
            }
        /*
         * 
         * end % if computer type
         */
        }
        /*
         * 
         * %---------------------------------------------------------------------------   
         * % Consolidate OS status reply. 
         * % We consistently return Success = false if anything on error or warning. 
         * Success = ConsolidateMkdirStatus(Status,OSMessage);      
         */
        mlfAssign(
          &Success,
          mlfMkdir_ConsolidateMkdirStatus(
            mclVv(Status, "Status"), mclVv(OSMessage, "OSMessage")));
        /*
         * 
         * % throw applicable OS errors.
         * if ~Success
         */
        if (mclNotBool(mclVv(Success, "Success"))) {
            /*
             * error('MATLAB:MKDIR:OSError','%s',strvcat(OSMessage,ErrorMessage)') 
             */
            mlfError(
              _mxarray44_,
              _mxarray46_,
              mlfCtranspose(
                mlfStrvcat(
                  mclVv(OSMessage, "OSMessage"),
                  mclVv(ErrorMessage, "ErrorMessage"),
                  NULL)),
              NULL);
        /*
         * end
         */
        }
    /*
     * 
     * catch
     */
    } mlfCatch {
        /*
         * Success = false;
         */
        mlfAssign(&Success, mlfFalse(NULL));
        /*
         * [ErrorMessage,ErrorID] = lasterr;
         */
        mlfAssign(&ErrorMessage, mlfLasterr(&ErrorID, NULL, NULL));
        /*
         * % extract descriptive lines from error message
         * if ~isempty(ErrorMessage)
         */
        if (mclNotBool(mlfIsempty(mclVv(ErrorMessage, "ErrorMessage")))) {
            /*
             * ErrorMessage = strread(ErrorMessage,'%s','delimiter','\n');
             */
            mlfAssign(
              &ErrorMessage,
              mlfNStrread(
                0,
                mclValueVarargout(),
                mclVv(ErrorMessage, "ErrorMessage"),
                _mxarray46_,
                _mxarray48_,
                _mxarray50_,
                NULL));
            /*
             * ErrorMessage = strvcat(ErrorMessage(2:end));
             */
            mlfAssign(
              &ErrorMessage,
              mlfStrvcat(
                mclArrayRef1(
                  mclVv(ErrorMessage, "ErrorMessage"),
                  mlfColon(
                    _mxarray1_,
                    mlfEnd(
                      mclVv(ErrorMessage, "ErrorMessage"),
                      _mxarray0_,
                      _mxarray0_),
                    NULL)),
                NULL));
        /*
         * end
         */
        }
        /*
         * % throw error if no output arguments are specified
         * if ~nargout 
         */
        if (svDoubleScalarEq((double) nargout_, 0.0)) {
            /*
             * error(ErrorID,'%s',ErrorMessage');
             */
            mlfError(
              mclVv(ErrorID, "ErrorID"),
              _mxarray46_,
              mlfCtranspose(mclVv(ErrorMessage, "ErrorMessage")),
              NULL);
        /*
         * end
         */
        }
    /*
     * end
     */
    } mlfEndCatch
    /*
     * 
     * %------------------------------------------------------------------------------
     * % parse output values to output parameters, if outout arguments are specified
     * if nargout
     */
    if (nargout_ != 0) {
        /*
         * varargout{1} = Success;
         */
        mlfIndexAssign(
          &varargout, "{?}", _mxarray0_, mclVv(Success, "Success"));
        /*
         * varargout{2} = ErrorMessage;
         */
        mlfIndexAssign(
          &varargout, "{?}", _mxarray1_, mclVv(ErrorMessage, "ErrorMessage"));
        /*
         * varargout{3} = ErrorID;
         */
        mlfIndexAssign(
          &varargout, "{?}", _mxarray9_, mclVv(ErrorID, "ErrorID"));
    /*
     * end
     */
    }
    /*
     * %==============================================================================
     * % end of MKDIR
     * 
     * 
     * % ConsolidateMkdirStatus. Consolidate the status returns in COPYFILE into a
     * %     success logical output
     * % Input:
     * %        Status: scalar double defining the status output from OS calls
     * %        OSMessage: string array defining OS call message outputs
     * % Return:
     * %        Success: logical scalar defining outcome of COPYFILE
     * %------------------------------------------------------------------------------
     */
    return_:
    mxDestroyArray(ArgError);
    mxDestroyArray(ans);
    mxDestroyArray(ArgOutError);
    mxDestroyArray(Success);
    mxDestroyArray(OldDir);
    mxDestroyArray(ErrorMessage);
    mxDestroyArray(ErrorID);
    mxDestroyArray(Status);
    mxDestroyArray(OSMessage);
    mxDestroyArray(PreWin2000);
    mxDestroyArray(DirName);
    mxDestroyArray(NewDirName);
    mxDestroyArray(Directory);
    mxDestroyArray(WarningMessage);
    mxDestroyArray(WarningID);
    mxDestroyArray(WinSwitches);
    mxDestroyArray(varargin);
    mclSetCurrentLocalFunctionTable(save_local_function_table_);
    return varargout;
}

/*
 * The function "Mmkdir_ConsolidateMkdirStatus" is the implementation version
 * of the "mkdir/ConsolidateMkdirStatus" M-function from file
 * "c:\matlab65\toolbox\matlab\general\mkdir.m" (lines 201-226). It contains
 * the actual compiled code for that M-function. It is a static function and
 * must only be called from one of the interface functions, appearing below.
 */
/*
 * function [Success] = ConsolidateMkdirStatus(Status,OSMessage)
 */
static mxArray * Mmkdir_ConsolidateMkdirStatus(int nargout_,
                                               mxArray * Status,
                                               mxArray * OSMessage) {
    mexLocalFunctionTable save_local_function_table_
      = mclSetCurrentLocalFunctionTable(&_local_function_table_mkdir);
    mxArray * Success = NULL;
    mclCopyArray(&Status);
    mclCopyArray(&OSMessage);
    /*
     * %------------------------------------------------------------------------------
     * switch Status
     */
    {
        mxArray * v_ = mclInitialize(mclVa(Status, "Status"));
        if (mclSwitchCompare(v_, _mxarray13_)) {
            /*
             * 
             * case 0
             * if isempty(OSMessage)
             */
            if (mlfTobool(mlfIsempty(mclVa(OSMessage, "OSMessage")))) {
                /*
                 * Success = true; % no error
                 */
                mlfAssign(&Success, mlfTrue(NULL));
            /*
             * else
             */
            } else {
                /*
                 * % an error with zero status value occurred (originates from WIN95/98/ME)
                 * Success = false; 
                 */
                mlfAssign(&Success, mlfFalse(NULL));
            /*
             * end
             */
            }
        /*
         * 
         * otherwise
         */
        } else {
            /*
             * Success = false; % some error or warning was returned by the OS call
             */
            mlfAssign(&Success, mlfFalse(NULL));
        /*
         * end
         */
        }
        mxDestroyArray(v_);
    }
    mclValidateOutput(
      Success, 1, nargout_, "Success", "mkdir/ConsolidateMkdirStatus");
    mxDestroyArray(OSMessage);
    mxDestroyArray(Status);
    mclSetCurrentLocalFunctionTable(save_local_function_table_);
    return Success;
    /*
     * %------------------------------------------------------------------------------
     * return
     * % end of ConsolidateMkdirStatus
     * %==============================================================================
     * 
     * % SETWINMKDIR. determine Windows platform
     * % Return:
     * %        WinCopySwitches: struct scalar defining copy and xcopy switches
     * %           .PreWin2000: logical scalar defining pre or post Windows 2000 (0 or 1)
     * %------------------------------------------------------------------------------
     */
}

/*
 * The function "Mmkdir_setwinmkdir" is the implementation version of the
 * "mkdir/setwinmkdir" M-function from file
 * "c:\matlab65\toolbox\matlab\general\mkdir.m" (lines 226-251). It contains
 * the actual compiled code for that M-function. It is a static function and
 * must only be called from one of the interface functions, appearing below.
 */
/*
 * function [WinMkdirSwitches]=setwinmkdir
 */
static mxArray * Mmkdir_setwinmkdir(int nargout_) {
    mexLocalFunctionTable save_local_function_table_
      = mclSetCurrentLocalFunctionTable(&_local_function_table_mkdir);
    mxArray * WinMkdirSwitches = NULL;
    mxArray * WinVersion = NULL;
    mxArray * Status = NULL;
    /*
     * %------------------------------------------------------------------------------
     * % find version of Windows
     * [Status,WinVersion] = dos('ver');
     */
    mlfAssign(&Status, mlfDos(&WinVersion, _mxarray52_, NULL));
    /*
     * if length(strfind(WinVersion,'Windows 95')) || ...
     */
    if (mclLengthInt(mlfStrfind(mclVv(WinVersion, "WinVersion"), _mxarray54_))
        != 0
        || mclLengthInt(
             mlfStrfind(mclVv(WinVersion, "WinVersion"), _mxarray56_))
           != 0
        || mclLengthInt(
             mlfStrfind(mclVv(WinVersion, "WinVersion"), _mxarray58_))
           != 0) {
        /*
         * length(strfind(WinVersion,'Windows 98')) || ...
         * length(strfind(WinVersion,'Windows Millennium'))
         * WinMkdirSwitches.PreWin2000 = true;
         */
        mlfIndexAssign(&WinMkdirSwitches, ".PreWin2000", mlfTrue(NULL));
    /*
     * else
     */
    } else {
        /*
         * WinMkdirSwitches.PreWin2000 = false;
         */
        mlfIndexAssign(&WinMkdirSwitches, ".PreWin2000", mlfFalse(NULL));
    /*
     * end
     */
    }
    mclValidateOutput(
      WinMkdirSwitches, 1, nargout_, "WinMkdirSwitches", "mkdir/setwinmkdir");
    mxDestroyArray(Status);
    mxDestroyArray(WinVersion);
    mclSetCurrentLocalFunctionTable(save_local_function_table_);
    return WinMkdirSwitches;
    /*
     * %-------------------------------------------------------------------------------
     * return
     * %===============================================================================
     * 
     * % WINMKDIR. makes directory on various Windows platforms
     * % 
     * % Input:
     * %        Directory: string defining directory path
     * %        WinSwitches: struct defining Windows specific switches
     * %           .PreWin2000: logical scalar defining pre or post Windows 2000 (0 or 1)
     * % Return:
     * %        Status: OS command status
     * %        OSMessage: string containing OS message, if any.
     * %------------------------------------------------------------------------------
     */
}

/*
 * The function "Mmkdir_winmkdir" is the implementation version of the
 * "mkdir/winmkdir" M-function from file
 * "c:\matlab65\toolbox\matlab\general\mkdir.m" (lines 251-290). It contains
 * the actual compiled code for that M-function. It is a static function and
 * must only be called from one of the interface functions, appearing below.
 */
/*
 * function [Status,OSMessage]=winmkdir(Directory,WinSwitches)
 */
static mxArray * Mmkdir_winmkdir(mxArray * * OSMessage,
                                 int nargout_,
                                 mxArray * Directory,
                                 mxArray * WinSwitches) {
    mexLocalFunctionTable save_local_function_table_
      = mclSetCurrentLocalFunctionTable(&_local_function_table_mkdir);
    mxArray * Status = NULL;
    mxArray * i = NULL;
    mxArray * _T1_ = NULL;
    mxArray * ext = NULL;
    mxArray * _T0_ = NULL;
    mxArray * subtree = NULL;
    mxArray * nrlevels = NULL;
    mxArray * parentDir = NULL;
    mclCopyArray(&Directory);
    mclCopyArray(&WinSwitches);
    /*
     * %------------------------------------------------------------------------------
     * if WinSwitches.PreWin2000
     */
    if (mlfTobool(
          mlfIndexRef(mclVa(WinSwitches, "WinSwitches"), ".PreWin2000"))) {
        /*
         * % Pre Windows 2000 we need to make a subtree iteratively, since DOS MKDIR
         * % cannot make a subdirectory tree at once. 
         * 
         * % Temporarily strip double quotes.
         * parentDir = strrep(Directory,'"',''); 
         */
        mlfAssign(
          &parentDir,
          mlfStrrep(mclVa(Directory, "Directory"), _mxarray32_, _mxarray12_));
        /*
         * % count subdirectory tree levels up from bottom of directory tree.
         * nrlevels = 0; 
         */
        mlfAssign(&nrlevels, _mxarray13_);
        /*
         * 
         * % Find path depth at which directory tree exists.
         * while isempty(dir(parentDir))
         */
        while (mlfTobool(
                 mlfIsempty(mlfNDir(1, mclVv(parentDir, "parentDir"))))) {
            /*
             * nrlevels = nrlevels+1;
             */
            mlfAssign(
              &nrlevels, mclPlus(mclVv(nrlevels, "nrlevels"), _mxarray0_));
            mlfAssign(&_T0_, mclVv(nrlevels, "nrlevels"));
            mlfAssign(&_T1_, mclVv(nrlevels, "nrlevels"));
            /*
             * [parentDir,subtree{nrlevels},ext{nrlevels}] = fileparts(parentDir);
             */
            mclFeval(
              mlfIndexVarargout(
                &parentDir, "", &subtree, "{?}", _T0_, &ext, "{?}", _T1_, NULL),
              mlxFileparts,
              mclVv(parentDir, "parentDir"),
              NULL);
        /*
         * end
         */
        }
        /*
         * 
         * % Build subdirectory tree recursively.
         * for i  = nrlevels:-1:1
         */
        {
            mclForLoopIterator viter__;
            for (mclForStart(
                   &viter__,
                   mclVv(nrlevels, "nrlevels"),
                   _mxarray8_,
                   _mxarray0_);
                 mclForNext(&viter__, &i);
                 ) {
                /*
                 * parentDir = validpath(parentDir,[subtree{i},ext{nrlevels}]);
                 */
                mlfAssign(
                  &parentDir,
                  mlfMkdir_validpath(
                    mclVv(parentDir, "parentDir"),
                    mlfHorzcat(
                      mlfIndexRef(
                        mclVv(subtree, "subtree"), "{?}", mclVv(i, "i")),
                      mlfIndexRef(
                        mclVv(ext, "ext"), "{?}", mclVv(nrlevels, "nrlevels")),
                      NULL)));
                /*
                 * [Status, OSMessage] = dos(['mkdir ', parentDir]);
                 */
                mlfAssign(
                  &Status,
                  mlfDos(
                    OSMessage,
                    mlfHorzcat(
                      _mxarray60_, mclVv(parentDir, "parentDir"), NULL),
                    NULL));
            /*
             * end
             */
            }
            mclDestroyForLoopIterator(viter__);
        }
    /*
     * 
     * else
     */
    } else {
        /*
         * % make new directory
         * [Status, OSMessage] = dos(['mkdir ' Directory]);
         */
        mlfAssign(
          &Status,
          mlfDos(
            OSMessage,
            mlfHorzcat(_mxarray60_, mclVa(Directory, "Directory"), NULL),
            NULL));
    /*
     * end
     */
    }
    mclValidateOutput(Status, 1, nargout_, "Status", "mkdir/winmkdir");
    mclValidateOutput(*OSMessage, 2, nargout_, "OSMessage", "mkdir/winmkdir");
    mxDestroyArray(parentDir);
    mxDestroyArray(nrlevels);
    mxDestroyArray(subtree);
    mxDestroyArray(_T0_);
    mxDestroyArray(ext);
    mxDestroyArray(_T1_);
    mxDestroyArray(i);
    mxDestroyArray(WinSwitches);
    mxDestroyArray(Directory);
    mclSetCurrentLocalFunctionTable(save_local_function_table_);
    return Status;
    /*
     * %-------------------------------------------------------------------------------
     * return
     * %===============================================================================
     * 
     * % VALIDPATH. makes directory on various Windows platforms
     * % 
     * % Input:
     * %        DirName: string defining parent directory
     * %        NewDirName: string defining new directory
     * % Return:
     * %        Directory: string defining full path to new directory
     * %------------------------------------------------------------------------------
     */
}

/*
 * The function "Mmkdir_validpath" is the implementation version of the
 * "mkdir/validpath" M-function from file
 * "c:\matlab65\toolbox\matlab\general\mkdir.m" (lines 290-309). It contains
 * the actual compiled code for that M-function. It is a static function and
 * must only be called from one of the interface functions, appearing below.
 */
/*
 * function [Directory] = validpath(DirName,NewDirName)
 */
static mxArray * Mmkdir_validpath(int nargout_,
                                  mxArray * DirName,
                                  mxArray * NewDirName) {
    mexLocalFunctionTable save_local_function_table_
      = mclSetCurrentLocalFunctionTable(&_local_function_table_mkdir);
    mxArray * Directory = NULL;
    mxArray * remainder = NULL;
    mxArray * firstPathPart = NULL;
    mclCopyArray(&DirName);
    mclCopyArray(&NewDirName);
    /*
     * %------------------------------------------------------------------------------
     * % Add double quotes around the source and destination files 
     * %	so as to support file names containing spaces. 
     * 
     * Directory = ['"' fullfile(DirName,NewDirName) '"'];
     */
    mlfAssign(
      &Directory,
      mlfHorzcat(
        _mxarray32_,
        mlfFullfile(
          mclVa(DirName, "DirName"), mclVa(NewDirName, "NewDirName"), NULL),
        _mxarray32_,
        NULL));
    /*
     * 
     * % place ~ outside quoted path, otherwise UNIX would not translate ~
     * if strcmp(Directory(1:2),'"~') 
     */
    if (mlfTobool(
          mlfStrcmp(
            mclArrayRef1(
              mclVv(Directory, "Directory"),
              mlfColon(_mxarray0_, _mxarray1_, NULL)),
            _mxarray62_))) {
        /*
         * if length(Directory)>4
         */
        if (mclLengthInt(mclVv(Directory, "Directory")) > 4) {
            /*
             * [firstPathPart,remainder] = strtok(Directory,filesep);
             */
            mlfAssign(
              &firstPathPart,
              mlfNStrtok(
                2, &remainder, mclVv(Directory, "Directory"), mlfFilesep()));
            /*
             * Directory = [firstPathPart(2:end),'/"',remainder(2:end)];
             */
            mlfAssign(
              &Directory,
              mlfHorzcat(
                mclArrayRef1(
                  mclVv(firstPathPart, "firstPathPart"),
                  mlfColon(
                    _mxarray1_,
                    mlfEnd(
                      mclVv(firstPathPart, "firstPathPart"),
                      _mxarray0_,
                      _mxarray0_),
                    NULL)),
                _mxarray64_,
                mclArrayRef1(
                  mclVv(remainder, "remainder"),
                  mlfColon(
                    _mxarray1_,
                    mlfEnd(
                      mclVv(remainder, "remainder"), _mxarray0_, _mxarray0_),
                    NULL)),
                NULL));
        /*
         * else
         */
        } else {
            /*
             * Directory = DirName;
             */
            mlfAssign(&Directory, mclVa(DirName, "DirName"));
        /*
         * end
         */
        }
    /*
     * end
     */
    }
    mclValidateOutput(Directory, 1, nargout_, "Directory", "mkdir/validpath");
    mxDestroyArray(firstPathPart);
    mxDestroyArray(remainder);
    mxDestroyArray(NewDirName);
    mxDestroyArray(DirName);
    mclSetCurrentLocalFunctionTable(save_local_function_table_);
    return Directory;
    /*
     * %-------------------------------------------------------------------------------
     * return
     * %===============================================================================
     */
}
